#ifndef __NCI_CONFIGURATION_H
#define __NCI_CONFIGURATION_H

#include "hardware.h"

/******************************************* 
* Manufacturer Configuration
* NFCForum-TS-NCI-1.0 2012-11-06
*******************************************/
//table 6/7
#define KEEP_CONFIG                     0x00
#define RESET_CONFIG                    0x01
#define REASON_CODE                     0x00
#define NCI_VERSION                     0x10
//table 9
#define NFCC_FEAT1                      0x01
#define NFCC_FEAT2                      0x06
#define NFCC_FEAT3                      0x00
#define NFCC_FEAT4                      0x00
#define NR_OF_SUPPORTED_RF_INTERFACES   0x03
#define SUPPORTED_RF_INTERFACES_1       0x01
#define SUPPORTED_RF_INTERFACES_2       0x02
#define SUPPORTED_RF_INTERFACES_3       0x03
#define MAX_LOGIC_CONN                  0x0E
//#define MAX_ROUT_TABLE_SIZE1            0x00
//#define MAX_ROUT_TABLE_SIZE2            0x00
#define MAX_CTRL_PACKET_PAYL_SIZE       0xFF
#define MAX_SIZE_LARGE_PARAMS1          0x64
#define MAX_SIZE_LARGE_PARAMS2          0x00
//table 13
#define MAX_DATA_PACKET_PAYL_SIZE       0xFF

/******************************************* 
* NCI include/exclude Configuration
*******************************************/
//#define NO_NFCEE
//#define NO_LISTENMODE
//#define NO_RF_MANAGEMENT_HANDLER
//#define NO_RF_COMMUNICATION_HANDLER
#define NO_HCI_CARD_GATES //HCI related Card Gates are not included if defined.
#define NO_PROPERIETARY_HANDLER


/******************************************* 
* NFCEE Configuration 
*******************************************/
#define MAX_SUPPORTED_NFCEES            0x03
#define MAX_SUPPORTED_PROTOCOLS         0x03

#define NFCEE_1                         0x00
#define NFCEE_2                         0x01
#define NFCEE_3                         0x02

#define NFCEE_PROTOCOL_HCI              0x00
#define NFCEE_PROTOCOL_DCLB             0x01
#define NFCEE_PROTOCOL_SPE              0x02

/******************************************* 
* Buffer size Definitions. Be careful with them!
*******************************************/
#define MAX_APP_DATA_LEN        50  //for Type-A
#define MAX_HIGHER_LAYER_LEN    50  //for Type-B



#endif //__NCI_CONFIGURATION_H
